{smcl}
{* *! version 1.0.0 4aug2014}{...}
{title:Title}

{phang}
{bf:svarih bfanelli {hline 2}} Heteroskedasticity-identified SVAR models, Bacchiocchi/Fanelli (2012) methodology


{marker syntax}{...}
{title:Syntax}

{p 12 27 2}
{cmd:svarih {ul:bfa}nelli}
{depvarlist}
{ifin}
{cmd:,}
{opt rgmv:ar(rgmvarname)}
[{it:optional_options}]{p_end}

{synoptset 37 tabbed}{...}
{marker options}{...}
{synopthdr:options}
{synoptline}
{syntab:Model: IH part}
{synopt:{opt rgmv:ar(rgmvarname)}}identify regimes by contents of variable {it:rgmvarname}{p_end}
{synopt:{opt bcon:straints(constraints_b)}}apply previously defined {it:constraints_b} to {bf:B}{p_end}
{synopt:{opt be:q(matrix_beq)}}define and apply to {bf:B} equality constraint matrix {it:matrix_beq}{p_end}
{synopt:{opt bc:ns(matrix_bcns)}}define and apply to {bf:B} cross-parameter constraint matrix {it:matrix_bcns}{p_end}
{synopt:{opt e#con:straints(constraints_e#)}}apply previously defined {it:constraints_e#} to {bf:E#}, for 2 {ul:<} # {ul:<} 4{p_end}
{synopt:{opt e#e:q(matrix_e#eq)}}define and apply to {bf:E#} equality constraint matrix {it:matrix_e#eq}, for 2 {ul:<} # {ul:<} 4{p_end}
{synopt:{opt e#c:ns(matrix_e#cns)}}define and apply to {bf:E#} cross-parameter constraint matrix {it:matrix_e#cns}, for 2 {ul:<} # {ul:<} 4{p_end}
{synopt:{opt noiden:check}}do not check for local identification{p_end}

{syntab:Model: VAR part}
{synopt:{opth la:gs(numlist)}}use lags {it:numlist} in the underlying VAR{p_end}
{synopt:{opth ex:og(varlist:varlist_exog)}}use exogenous variables {it:varlist_exog}{p_end}
{synopt:{opt nocons:tant}}suppress constant term{p_end}
{synopt:{opt dfk}}make small-sample degrees-of-freedom adjustment{p_end}
{synopt:{opt sm:all}}report small-sample t and F statistics{p_end}

{syntab:Reporting and screen output}
{synopt:{opt l:evel(#)}}set confidence level{p_end}
{synopt:{opt var}}display underlying {opt var} output{p_end}
{synopt:{opt nocnsr:eport}}do not display constraints{p_end}
{synopt:{opt not:able}}do not display estimation results table{p_end}
{synopt:{it:{help svarih_bfa##display_options:display_options}}}control column formats{p_end}

{syntab:Maximization}
{synopt:{opt evalm:ode(modenum)}}choose between d0, d1, and d2 evaluators; rarely used{p_end}
{synopt:{it:{help svarih_bfa##maximize_options:maximize_options}}}control the maximization process{p_end}

{synopt :{opt coefl:egend}}display legend instead of statistics{p_end}
{synoptline}

{p 4 6 2}You must {cmd:tsset} your data before using {opt svarih bfanelli}; see {helpb tsset:[TS] tsset}. {p_end}
{p 4 6 2}{it:varlist_exog} may contain time-series operators; see {help tsvarlist}.{p_end}
{p 4 6 2}{it:depvarlist} may NOT contain time-series operators.{p_end}
{p 4 6 2}See {help svarih_postestimation:svarih postestimation} for features available after estimation.{p_end}


{marker description}{...}
{title:Description}

{pstd}
{cmd:svarih bfanelli} provides an alternative identification scheme for structural VARs than those implemented in {help svar}.
It implements a variant of the the "Identification through Heteroskedasticity" (IH) method as put forth in {help svarih_bfa##BF2012:Bacchiocchi/Fanelli (2012)}.
Differently than {help svarih bacchiocchi} and {help svarih llutkepohl}, it does not assume stability of the VAR parameters across volatility regimes.
For details of the model setup, see the {help svarih_bfa##remarks:Remarks} section.
For general information on IH methods and for other IH methods that are available, see {help svarih}.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation}

{pstd}
This help entry uses abbreviations and definitions from {help svarih##abbreviations:svarih}.


{marker options}{...}
{title:Options}

{dlgtab:Model: IH part}

{phang}
{opt rgmv:ar(rgmvarname)} determines the variable whose observations identify the volatility regimes.
It must be a numeric variable holding non-negative integer values between 1 and 4 where each integer value identifies a particular volatility regime.

{pmore}
Differently than {help svarih bacchiocchi}, the regime encoding for {cmd:svarih bfanelli} is hardcoded in the following way:
The baseline state (shock impact matrix B) is encoded by {it:rgmvar}==1.
Its constraints are defined by options {opt bconstraints()}, {opt beq()}, and {opt bcns()}.
There must be at least another volatility regime in the sample, represented by the paramter matrix E2.
Its constraints are defined by options {opt e2constraints()}, {opt e2eq()}, and {opt e2cns()}.
This state is encoded by {it:rgmvar}==2.
There can be up to two additional volatility regimes in the model, represented by the paramter matrices E3 and E4.
The constraint specification and the regime encoding is done in an analogous fashion to the second volatility state and uses integers 3 and 4.

{pmore}
In any model specification, the volatility encodings that occur in the sample must be contiguous.
For example, you cannot estimate a model whose {it:rgmvar} has values 1, 2, and 4 in the estimation sample.
If you want to run this specification, you need to recode {it:rgmvar} or generate a different {it:rgmvar} that carries encodings 1, 2, and 3.

{pmore}
Such a situation can occur if you restrict the estimation sample through the {ifin} conditions.
Assume that you have data for 1970m1-1999m12 and variable {cmd:year} holds the year of observations.
You define regimes such that {it:rgmvar}==1,2,3 for observations in the 70s, 80s, 90s, respectively.
After defining sufficient constraints you can estimate the model for the entire sample and pass the local identification check.
However, if you want to exclude the 80s from the sample by typing

{pmore2}{...}
{input:. svarih bfa {it:(...)} if !inrange(year,1980,1989) {it:(...)}}

{pmore}
you will receive an error, since {it:rgmvar} only holds values 1 and 3 in the restricted estimation sample, which are not contiguous.
The solution is to generate a different {it:rgmvar} with state 3 recoded to 2, and using {cmd:e2} constraint options rather than {cmd:e3} constraint options.

{pmore}
Despite these limitations, the following still holds true:
It is not a requirement that a particular regime has contiguous observations in time.
There can be data gaps within a regime and between regimes.
The sequence of regimes and the number of occurrences of one particular regime is unrestricted.
For example, a regime sequence 2, 4, ., 4, 1, ., 3 can be accommodated by {cmd:svarih bfanelli} (a dot indicates missing values for {it:rgmvar} or data gaps).

{phang}
{opt bcon:straints(constraints_b)}, {opt be:q(matrix_beq)}, {opt bc:ns(matrix_bcns)} have the same meaning and can be specified in a similar manner as {opt bconstraints}, {opt beq}, {opt bcns} in {cmd:svar}.
See the exposition {help svar:there}.
They define linear constraints on the baseline state shock impact matrix B.
A difference to {cmd:svar} is that {opt bcon:straints()} does accept restrictions across model matrices B, E2, E3 and E4.

{pmore}
{opt be:q(matrix_beq)} defines equality constraints.
{it:matrix_beq} usually is an existing matrix but it may also be an expression as in {help matrix input} or a simple matrix function.
For example, {cmd:beq((.,0\.,.))} and {cmd:beq(I(2))} are allowed

{pmore}
{opt bc:ns(matrix_bcns)} defines cross-equation constraints.
Argument {it:matrix_bcns} can be supplied in the same way as {it:matrix_beq} from option {opt beq()}.

{pmore}
{opt bcon:straints(constraints_b)} can define either one.
They are defined using the {help constraint} command.

{phang}
{opt e#con:straints(constraints_e#)}, {opt e#e:q(matrix_e#eq)}, {opt e#c:ns(matrix_e#cns)}, where {it:#} must be an integer in the range 2 {ul:<} # {ul:<} 4, work in the same way as {opt bconstraints}, {opt beq} and {opt bcns}.
The define linear constraints on the shock impact modification matrices E2, E3, and E4.

{phang}
{opt noiden:check} skips the check for local identification of parameters.
The check consists of examining the rank of a matrix at the parameter estimates.
Full rank of this matrix is needed for identification.
For details, see the associated PDF document to {cmd:svarih} or the working paper by {help svarih_bfa##BF2012:Bacchiocchi/Fanelli (2012)}.

{dlgtab:Model: VAR part}

{phang}
{opt la:gs(numlist)} see {help var} / {help svar}.

{phang}
{opth "exog(varlist:varlist_exog)"} see {help var} / {help svar}.

{phang}
{opt nocons:tant}; see
{bf:{help estimation options##noconstant:[R] estimation options}}.

{phang}
{opt dfk} see {help var} / {help svar}.

{phang}
{opt sm:all} see {help var} / {help svar}.

{dlgtab:Reporting and screen output}

{phang}
{opt l:evel(#)}; see
{bf:{help estimation options##level():[R] estimation options}}.

{phang}
{opt var} specifies that the output from {opt var} also be displayed.
Note that there are multiple VARs underlying {cmd:svarih bfanelli}.
By default, these VARs are fit {helpb quietly}.
This option is not available when you replay estimates.

{phang}
{opt nocnsr:eport}; see {helpb estimation options##nocnsreport:[R] estimation options}.

{phang}
{opt not:able} does not display the estimation output table.

{marker display_options}{...}
{phang}
{it:display_options}: {opth cformat(%fmt)}, {opt pformat(%fmt)}, and {opt sformat(%fmt)};
see {helpb estimation options##display_options:[R] estimation options}.

{dlgtab:Maximization}

{phang}
{opt evalm:ode(modenum)} will choose between d0, d1, and d2 evaluators.
Rarely used.
The default is 2.
Can be used to check the numerical robustness of large models.

{marker maximize_options}{...}
{phang}
{it:maximize_options}:
{opt dif:ficult},
{opth tech:nique(maximize##algorithm_spec:algorithm_spec)},
{opt iter:ate(#)},
[{cmdab:no:}]{opt lo:g},
{opt tr:ace},
{opt grad:ient},
{opt showstep},
{opt hess:ian},
{opt showtol:erance},
{opt tol:erance(#)},
{opt ltol:erance(#)},
{opt nrtol:erance(#)},
{opt nonrtol:erance(#)}, and
{opt from(init_specs)};
see {manhelp maximize R}.

{phang}
{opt coeflegend}; see {helpb estimation options##coeflegend:[R] estimation options}.


{marker remarks}{...}
{title:Remarks}

{pstd}
{cmd:svarih bfanelli} implements the IH-BFA method within a maximum likelihood framework as an extended SVAR B-model.
The extension consists of positing a priori knowledge about different regimes of volatility, i.e. time periods during which the structural shocks have different variances and possibly nonzero covariances.
Consequently, a prerequisite for estimation is the specification of a variable that identifies these regimes, which in the following is referred to as the "regime variable".
The distinguishing feature of IH-BFA within the class of SVAR-IH methods is that it does not assume constancy of the VAR model parameters across regimes.

{pstd}
In terms of a typical structural VAR equation that relates VAR residuals u_t to structural shocks e_t, the model in Baccchiocchi/Fanelli (2012) reads

{p 40 40}
(1a)   u_t = B*e_t , t is in regime 1{break}
(1b)   u_t = (B+E2)*e_t , t is in regime 2{break}
(1c)   u_t = (B+E3)*e_t , t is in regime 3{break}
(1d)   u_t = (B+E4)*e_t , t is in regime 4

{pstd}
As usual, B models the contemporaneous impact of shocks.
E2, E3, and E4 model the volatility differentials between regimes 1 and 2, 3, 4.

{pstd}
Note that even if all E# matrices in the model are constrained to null matrices, (1a)-(1d) do not collapse into a standard SVAR B-model implemented in {help svar} since each regime has its own separate underlying VAR regressions.


{marker examples}{...}
{title:Examples}

{pstd}
The following example illustrates the mechanics of IH-BFA.
It does not discuss the important issues of the interpretation of the shocks.
It focuses on the mechanics.
It leans on the example given in {cmd:svar} so you can compare the {cmd:svarih bfa} setup to the one of {cmd:svar}.

{pstd}
Throughout this example section, we store estimated results in Stata's estimation results catalogue for later access.
The utility {help svarih examples} allows you to easily re-generate these estimates at any point.

{pstd}
In order to apply IH-BFA, we first must define a regime variable.
To that end, we make the following assumptions:
We have prior knowledge that the volatilities of the shocks in our model have changed in the 1970s.
In addition, we have evidence that slope coefficients of the underlying VAR also have changed at the same time.
We fix a date of regime change for 1974q1.
The statement below generates a variable that contains values 1 and 2, as required by a {cmd:svarih bfa} model with two regimes.

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata gen byte rgmvar = (qtr>=tq(1974q1)) + 1:. gen byte rgmvar = (qtr>=tq(1974q1)) + 1}{p_end}

{pstd}
It is worth reiterating that the occurence of regimes can be modeled to be much more complicated than this.
Any sequence and any multiplicity of regimes, with any occurence of gaps in the data, are allowed.
If there are enough observations, {cmd:svarih bfa} will produce estimates.

{pstd}
Before estimation, we have to decide which constraints we impose.
Let's start with a lower triangular shock impact matrix in both regimes.

{phang2}{stata matrix beq = (.,0,0 \ .,.,0 \ .,.,.):. matrix beq = (.,0,0 \ .,.,0 \ .,.,.)}{p_end}
{phang2}{stata matrix e2eq = beq:. matrix e2eq = beq}{p_end}
{phang2}{stata svarih bfa dln_inv dln_inc dln_consump , rgmvar(rgmvar) beq(beq) e2eq(e2eq):. svarih bfa dln_inv dln_inc dln_consump , rgmvar(rgmvar) beq(beq) e2eq(e2eq)}{p_end}
{phang2}{stata est store bfa_svarrepl:. est store bfa_svarrepl}{p_end}

{pstd}
To illustrate the relation of IH-BFA to SVAR models, we run two subsample SVARs, one for each regime.

{phang2}{stata matrix aeq = I(3):. matrix aeq = I(3)}{p_end}
{phang2}{stata svar dln_inv dln_inc dln_consump if rgmvar==1, aeq(aeq) beq(beq):. svar dln_inv dln_inc dln_consump if rgmvar==1, aeq(aeq) beq(beq)}{p_end}
{phang2}{stata est store bfa_svar1:. est store bfa_svar1}{p_end}
{phang2}{stata svar dln_inv dln_inc dln_consump if rgmvar==2, aeq(aeq) beq(beq):. svar dln_inv dln_inc dln_consump if rgmvar==2, aeq(aeq) beq(beq)}{p_end}
{phang2}{stata est store bfa_svar2:. est store bfa_svar2}{p_end}

{pstd}
The {cmd:svarih bfa} B-matrix estimates are identical to the {cmd:svar} B-matrix estimates for the regime 1 subsample.
The sum of the {cmd:svarih bfa} B and E-matrix estimates corresponds to the {cmd:svar} B-matrix estimates for the regime 2 subsample.
We compare the first subsample:

{phang2}{stata estimates table bfa_svarrepl bfa_svar1 , p stats(ll N):. estimates table bfa_svarrepl bfa_svar1 , p stats(ll N)}{p_end}

{pstd}
To confirm the second claim we take advantage of the replay functionality of {cmd:svarih} invoked by the option {opt cmat}.

{phang2}{stata estimates restore bfa_svarrepl:. estimates restore bfa_svarrepl}{p_end}
{phang2}{stata svarih, cmat bpluse(2) format(%12.4f):. svarih, cmat bpluse(2) format(%12.4f)}{p_end}
{phang2}{stata estimates replay bfa_svar2 , nocnsreport:. estimates replay bfa_svar2 , nocnsreport}{p_end}

{pstd}
So far, there is nothing gained in comparison to SVAR models. IH-BFA, However, can achieve identification schemes not possible in SVAR models.
Below we relax the restriction on element B[1,2], but add some more restrictions to E2:
The resulting scheme allows for a differential impact of the first shock on the first two endogenous variables in regime 2, and of the second shock on the second model variable.

{phang2}{stata matrix beq  = (.,.,0 \ .,.,0 \ .,.,.):. matrix beq  = (.,.,0 \ .,.,0 \ .,.,.)}{p_end}
{phang2}{stata matrix e2eq = (.,0,0 \ .,.,0 \ 0,0,0):. matrix e2eq = (.,0,0 \ .,.,0 \ 0,0,0)}{p_end}
{phang2}{stata svarih bfa dln_inv dln_inc dln_consump , rgmvar(rgmvar) e2eq(e2eq) beq(beq):. svarih bfa dln_inv dln_inc dln_consump , rgmvar(rgmvar) e2eq(e2eq) beq(beq)}{p_end}
{phang2}{stata est store bfa_unconstr:. est store bfa_unconstr}{p_end}
{phang2}{stata svarih , cmat b e2 bpluse(2) format(%12.3f) star:. svarih , cmat b e2 bpluse(2) format(%12.3f) star}{p_end}

{pstd}
In order to perform a LR-test to test whether the two differential impacts on the second endogenous variable can be excluded, we estimate a constrained model:

{phang2}{stata matrix e2eq = (.,0,0 \ 0,0,0 \ 0,0,0):. matrix e2eq = (.,0,0 \ 0,0,0 \ 0,0,0)}{p_end}
{phang2}{stata svarih bfa dln_inv dln_inc dln_consump , rgmvar(rgmvar) e2eq(e2eq) beq(beq):. svarih bfa dln_inv dln_inc dln_consump , rgmvar(rgmvar) e2eq(e2eq) beq(beq)}{p_end}
{phang2}{stata est store bfa_constr:. est store bfa_constr}{p_end}
{phang2}{stata lrtest bfa_constr bfa_unconstr , stat:. lrtest bfa_constr bfa_unconstr , stat}{p_end}

{pstd}
The exclusion restrictions cannot be rejected at any conventional level.

{pstd}
{cmd:predict} after {cmd:svarih bfanelli} generates prediced values, residuals, shocks, and historical decompositions.
{cmd:dsimih} generates dynamic simulation statistics.
For all features available after estimation, see {help svarih postestimation}.


{marker saved_results}{...}
{title:Saved results}

{pstd}
{cmd:svarih bfanelli} saves the following in {cmd:e()}:

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Scalars}{p_end}
{synopt:{cmd:e(N)}}number of observations{p_end}
{synopt:{cmd:e(N_cns)}}number of constraints{p_end}
{synopt:{cmd:e(k_eq)}}number of equations in {cmd:e(b)}{p_end}
{synopt:{cmd:e(k_dv)}}number of dependent variables{p_end}
{synopt:{cmd:e(k_aux)}}number of auxiliary parameters{p_end}
{synopt:{cmd:e(ll)}}log likelihood{p_end}
{synopt:{cmd:e(N_var#)}}number of observations for VAR #{p_end}
{synopt:{cmd:e(N_gaps_var#)}}number of gaps in the sample for underlying VAR #{p_end}
{synopt:{cmd:e(k_var)}}number of coefficients in each underlying VAR{p_end}
{synopt:{cmd:e(k_eq_var)}}number of equations in each underlying VAR{p_end}
{synopt:{cmd:e(k_dv_var)}}number of dependent variables in each underlying VAR{p_end}
{synopt:{cmd:e(df_eq_var)}}average number of parameters in an equation of each underlying VAR{p_end}
{synopt:{cmd:e(df_r_var#)}}if {cmd:small}, VAR residual degrees of freedom for VAR #{p_end}
{synopt:{cmd:e(mlag)}}highest lag in VAR{p_end}
{synopt:{cmd:e(tmin_var#)}}first time period in the sample for VAR #{p_end}
{synopt:{cmd:e(tmax_var)}}maximum time for VAR #{p_end}
{synopt:{cmd:e(rank)}}rank of {cmd:e(V)}{p_end}
{synopt:{cmd:e(ic_ml)}}number of ML iterations{p_end}
{synopt:{cmd:e(rc_ml)}}return code from {cmd:ml}{p_end}
{synopt:{cmd:e(converged_ml)}}{cmd:1} if {cmd:ml} declared convergence, {cmd:0} otherwise{p_end}
{synopt:{cmd:e(numregimes)}}number of regimes marked by {it:regimevar}{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Macros}{p_end}
{synopt:{cmd:e(cmd)}}{cmd:svarih}{p_end}
{synopt:{cmd:e(method)}}{cmd:BFanelli}{p_end}
{synopt:{cmd:e(version)}}version number of command{p_end}
{synopt:{cmd:e(cmdline)}}command as typed{p_end}
{synopt:{cmd:e(lags)}}lags in model{p_end}
{synopt:{cmd:e(depvar)}}names of dependent variables{p_end}
{synopt:{cmd:e(rgmvar)}}name of variable that identifies regimes{p_end}
{synopt:{cmd:e(exog)}}names of exogenous variables, if specified{p_end}
{synopt:{cmd:e(nocons)}}noconstant, if {cmd:noconstant} specified{p_end}
{synopt:{cmd:e(cns_b)}}comprehensive list of constraints on B{p_end}
{synopt:{cmd:e(cns_e#)}}comprehensive list of constraints on E#{p_end}
{synopt:{cmd:e(dfk_var)}}alternate divisor ({cmd:dfk}), if specified{p_end}
{synopt:{cmd:e(small)}}{cmd:small}, if specified{p_end}
{synopt:{cmd:e(tsfmt)}}format of timevar{p_end}
{synopt:{cmd:e(timevar)}}name of timevar{p_end}
{synopt:{cmd:e(title)}}title in estimation output{p_end}
{synopt:{cmd:e(predict)}}program used to implement {cmd:predict}{p_end}
{synopt:{cmd:e(from)}}contents of maximization option {opt from}, if specified as a string{p_end}
{synopt:{cmd:e(mlopts)}}maximization options used{p_end}
{synopt:{cmd:e(idencheck)}}result of identification check; one of {cmd:passed}, {cmd:failed}, or {cmd:skipped}{p_end}
{synopt:{cmd:e(regimes)}}regime encodings that occur in sample{p_end}
{synopt:{cmd:e(regimes_Ns)}}number of observations in each regime{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Matrices}{p_end}
{synopt:{cmd:e(b)}}coefficient vector{p_end}
{synopt:{cmd:e(Cns)}}constraints matrix{p_end}
{synopt:{cmd:e(Sigma_var#)}}Residual covariance matrix for underlying VAR #{p_end}
{synopt:{cmd:e(V)}}variance-covariance matrix of the estimators{p_end}
{synopt:{cmd:e(b_var#)}}coefficient vector for underlying VAR #{p_end}
{synopt:{cmd:e(V_var#)}}VCE for underlying VAR #{p_end}
{synopt:{cmd:e(beq)}}{cmd:beq(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(bcns)}}{cmd:bcns(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(e#eq)}}{cmd:e#eq(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(e#cns)}}{cmd:e#cns(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(B)}}estimated B matrix{p_end}
{synopt:{cmd:e(E#)}}estimated E# matrix{p_end}
{synopt:{cmd:e(from)}}matrix of maximization option {opt from}, if specified as a matrix{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Functions}{p_end}
{synopt:{cmd:e(sample)}}marks estimation sample{p_end}
{p2colreset}{...}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
The code of official Stata's {cmd:svar} has served as a point of reference throughout the development of {cmd:svarih bfanelli}.
Any remaining errors in {cmd:svarih bfanelli} are mine.


{marker references}{...}
{title:References}

{marker BF2012}{...}
{phang}
Bacchiocchi, E. and L. Fanelli (2012): Identification in Structural Vector Autoregressive Models with Structural Changes.
Universita Degli Studi di Milano, Working Paper No.2012-16.


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb svar:[TS] svar},
{helpb svarih},
{helpb svarih bac},
{helpb svarih llu},
{helpb svarih postestimation},
{helpb svarih cmat},
{helpb dsimih}
{p_end}

